#ifndef _NEWPASSDLG_CPP
#define _NEWPASSDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <ShlOBJ.H>
#include <Stdlib.H>

#include "../Resources/Resource.H"

#include "../Headers/NSWFL.H"
#include "../Headers/Package.H"
#include "../Headers/Entry.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/OpenPassDlg.H"
#include "../Dialogs/NewPassDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND NewPassDialog_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK NewPassDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HMENU SystemMenu = NULL;

    static HWND Password1_hWnd = NULL;
    static HWND Password2_hWnd = NULL;
    static HWND PasswordBitsBar_hWnd = NULL;
    static HWND PasswordBits_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        NewPassDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        Password1_hWnd = GetDlgItem(xHandle, IDC_PASSWORD1);
        Password2_hWnd = GetDlgItem(xHandle, IDC_PASSWORD2);
        PasswordBitsBar_hWnd = GetDlgItem(xHandle, IDC_PASSWORDBAR2);
        PasswordBits_hWnd = GetDlgItem(xHandle, IDC_PASSWORDBITS2);

        Set_Text(Password1_hWnd, "9e8t49e8rt4389476i516se56");
        Set_Text(Password2_hWnd, "9e8t49e8rt4389476i516se56");

        CenterWindow(xHandle);

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == 307) // Key Down
    {
        float PasswordLen1   = 0;
        float PasswordLen2    = 0;
        float EffeciencyBits = 0;

        char LocalTemp[1024];

        PasswordLen1 = (float) SendMessage(Password1_hWnd, WM_GETTEXTLENGTH, 0, 0);
        PasswordLen2 = (float) SendMessage(Password2_hWnd, WM_GETTEXTLENGTH, 0, 0);

        HWND CurrentFocus = GetFocus();

        if(CurrentFocus == Password1_hWnd)
        {
            EffeciencyBits = (PasswordLen1 / 56) * 100;
            SendMessage(PasswordBitsBar_hWnd, PBM_SETPOS, (int) EffeciencyBits, 0);
            sprintf(LocalTemp," (%.0f Bits)", PasswordLen1 * 8);
            Set_Text(PasswordBits_hWnd,LocalTemp);
        }

        if(CurrentFocus == Password2_hWnd)
        {
            EffeciencyBits = (PasswordLen2 / 56) * 100;
            SendMessage(PasswordBitsBar_hWnd, PBM_SETPOS, (int) EffeciencyBits, 0);
            sprintf(LocalTemp," (%.0f Bits)", PasswordLen2 * 8);
            Set_Text(PasswordBits_hWnd,LocalTemp);
        }
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
        if(wParam == IDC_OK)
        {
            char lsPassword1[1024 + 1];
            char lsPassword2[1024 + 1];

            int Length1 = Get_TextEx(Password1_hWnd, lsPassword1, 1024);
            int Length2 = Get_TextEx(Password2_hWnd, lsPassword2, 1024);

            if((Length1 < 8 || Length1 > 1024) || (Length2 < 8 || Length2 > 1024))
            {
                MessageBox(xHandle, "Please enter the same password twice. Within 8 and 1,024 characters.", gsTitleCaption, 0);
                return TRUE;
            }

            if(strcmp(lsPassword1, lsPassword2) != 0)
            {
                MessageBox(xHandle, "The passwords you entered do not match.", gsTitleCaption, 0);
                return TRUE;
            }

            strcpy(gsPassword, lsPassword1);

            EndDialog(xHandle, 1);
            return TRUE;
        }

        if(wParam == IDC_CANCEL)
        {
            EndDialog(xHandle, 0);
            DestroyWindow(xHandle);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(xHandle, 0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

